/** <!------------------------------------------------------------------------->
*
*  @file CanIf_Cfg.c
*
*  @creationDate 21 February 2025 14:00:51
*
*  @brief Generated CanIf configuration source file.
*
*  @author
*
*  @description
*
*  @copyright
*    Copyright 2025, dSPACE GmbH. All rights reserved.
*
*  @version
*
*   <hr><br>
*<!-------------------------------------------------------------------------->*/

/* -- Include directives. -- */
#include "CanIf_Internal.h"
#include "CanIf.h"
#include "PduR_CanIf.h"
#if CANIF_CANTSYN_SUPPORT == STD_ON
#include "CanTSyn_CanIf.h"
#endif
#if CANIF_J1939TP_SUPPORT == STD_ON
#include "J1939Tp_CanIf.h"
#endif
#if CANIF_CDD_SUPPORT == STD_ON
#include "CDD_CanIf.h"
#endif
#include "CanIf_Cbk.h"
#include "CanIf_Cfg_BusAccess.h"
#include "SchM_CanIf.h"

#ifdef HOST_DEBUG
// if we are compiling this for HOST Debugging we need to be aware
// of virtual bus functions.
#include <DsCanBus.h>
#endif

/*----------------------------------------------------------------------------*/
/* PROFILING SUPPORT                                                          */
/*----------------------------------------------------------------------------*/
#ifdef CANIF_ENABLE_PROFILING
#include "DsApplicationInterface.h"
static DsTProfilerSource DsCanBoard_create_PROFILER_SRC;
static DsTProfilerSource DsCanCh_create_PROFILER_SRC;
#endif


CONST(uint8, AUTOMATIC) CanIf_DevErrorDetect = STD_OFF;
CONST(uint8, AUTOMATIC) CanIf_MultipleDriverSupport = STD_OFF;
CONST(uint8, AUTOMATIC) CanIf_PublicPNSupport = STD_OFF;
CONST(uint8, AUTOMATIC) CanIf_ReadRxPduDataApi = STD_OFF;
CONST(uint8, AUTOMATIC) CanIf_ReadTxPduNotifyStatusApi = STD_OFF;
CONST(uint8, AUTOMATIC) CanIf_ReadRxPduNotifyStatusApi = STD_OFF;
CONST(uint8, AUTOMATIC) CanIf_SetDynamicTxIdApi = STD_OFF;
CONST(uint8, AUTOMATIC) CanIf_DlcCheck = STD_OFF;
CONST(uint8, AUTOMATIC) CanIf_WakeupSupport = STD_ON;
CONST(CanIfSoftwareFilterType_Type, AUTOMATIC) CanIf_SoftwareFilterType = BINARY;
CONST(uint8, AUTOMATIC) CanIf_PublicWakeupCheckValidationSupport = STD_OFF;
CONST(uint8, AUTOMATIC) CanIf_TransmitCancellation = STD_OFF;
CONST(uint8, AUTOMATIC) CanIf_PublicTxConfirmPollingSupport = STD_OFF;
CONST(uint8, AUTOMATIC) CanIf_VersionInfoApi = STD_OFF;
CONST(uint8, AUTOMATIC) CanIf_MaxNumberOfHrh = 1;
CONST(uint8, AUTOMATIC) CanIf_NumberOfCanHWUnits = 1;

VAR(CanIfControllerFlags, AUTOMATIC) g_CntrlFlags[1] = {0}; /* For C98 compatibility this array has length 1 */
static VAR(uint8, AUTOMATIC) ga_CanIfReadRxPduNotifyStatus[3] = {0}; /* For C98 compatibility this array has length 1 */
static VAR(uint8, AUTOMATIC) ga_CanIfReadTxPduNotifyStatus[4] = {0}; /* For C98 compatibility this array has length 1 */
STATIC VAR(uint8, AUTOMATIC) ga_CanIfRxPduDataBuffer[1] = {0}; /* For C98 compatibility this array has length 1 */
STATIC VAR(uint32, AUTOMATIC) ga_CanIfDynamicTxPduCanIdArray[1] = {0}; /* For C98 compatibility this array has length 1 */
STATIC VAR(CanIf_RxIndicationMetaDataType, AUTOMATIC) ga_CanIfRxMetaData[1] = {0}; /* For C98 compatibility this array has length 1 */
STATIC VAR(CanIf_RxIndicationMetaDataType, AUTOMATIC) ga_CanIfRxInterruptMetaData[1] = {0}; /* For C98 compatibility this array has length 1 */

static CanIfTxPduConfig TxPduConfig[] = {
    /* ThermalCAN */
    { /* 0 */
        CanIf_ThermalCAN_Compressor_FrameTrig, /* CanIf Pdu Id */
        0, /* 0x00000000 CAN Id */
        CANIF_DLC_STANDARD, /* DLC TYPE */
        6, /* DLC */
        CANIF_PDU_TYPE_STATIC,
        0, /* Dynamic PDU index */
        FALSE, /* PduNotifyStatus */
        STANDARD_CAN, /* CAN Id Type */
        FALSE, /* GetTxPduPnFilterPdu */
        CANIF_PDUR, /* TX user */
        PduR_CanIfTxConfirmation, /* User confirmation */
        0, /* CanIfCanTxPduHthRef */
        0, /* PduIdRef */
        1, /* Queue size */
        0x00 /* Unused bit pattern */
    },
    { /* 1 */
        CanIf_ThermalCAN_TempBatt_FrameTrig, /* CanIf Pdu Id */
        4, /* 0x00000004 CAN Id */
        CANIF_DLC_STANDARD, /* DLC TYPE */
        8, /* DLC */
        CANIF_PDU_TYPE_STATIC,
        0, /* Dynamic PDU index */
        FALSE, /* PduNotifyStatus */
        STANDARD_CAN, /* CAN Id Type */
        FALSE, /* GetTxPduPnFilterPdu */
        CANIF_PDUR, /* TX user */
        PduR_CanIfTxConfirmation, /* User confirmation */
        1, /* CanIfCanTxPduHthRef */
        0, /* PduIdRef */
        1, /* Queue size */
        0x00 /* Unused bit pattern */
    },
    { /* 2 */
        CanIf_ThermalCAN_Temperatures_FrameTrig, /* CanIf Pdu Id */
        5, /* 0x00000005 CAN Id */
        CANIF_DLC_STANDARD, /* DLC TYPE */
        8, /* DLC */
        CANIF_PDU_TYPE_STATIC,
        0, /* Dynamic PDU index */
        FALSE, /* PduNotifyStatus */
        STANDARD_CAN, /* CAN Id Type */
        FALSE, /* GetTxPduPnFilterPdu */
        CANIF_PDUR, /* TX user */
        PduR_CanIfTxConfirmation, /* User confirmation */
        2, /* CanIfCanTxPduHthRef */
        0, /* PduIdRef */
        1, /* Queue size */
        0x00 /* Unused bit pattern */
    },
    { /* 3 */
        CanIf_ThermalCAN_Conditions_FrameTrig, /* CanIf Pdu Id */
        6, /* 0x00000006 CAN Id */
        CANIF_DLC_STANDARD, /* DLC TYPE */
        6, /* DLC */
        CANIF_PDU_TYPE_STATIC,
        0, /* Dynamic PDU index */
        FALSE, /* PduNotifyStatus */
        STANDARD_CAN, /* CAN Id Type */
        FALSE, /* GetTxPduPnFilterPdu */
        CANIF_PDUR, /* TX user */
        PduR_CanIfTxConfirmation, /* User confirmation */
        3, /* CanIfCanTxPduHthRef */
        0, /* PduIdRef */
        1, /* Queue size */
        0x00 /* Unused bit pattern */
    },
};

static CanIfHthConfig HthConfig[] = {
    /* ThermalCAN */
    {
            FULL_CAN, /* CanIfHthType */
            0,        /* CanIfCanControllerIdRef */
            0         /* CanIfHthIdSymRef */
    },
    {
            FULL_CAN, /* CanIfHthType */
            0,        /* CanIfCanControllerIdRef */
            0         /* CanIfHthIdSymRef */
    },
    {
            FULL_CAN, /* CanIfHthType */
            0,        /* CanIfCanControllerIdRef */
            0         /* CanIfHthIdSymRef */
    },
    {
            FULL_CAN, /* CanIfHthType */
            0,        /* CanIfCanControllerIdRef */
            0         /* CanIfHthIdSymRef */
    },
};

static VAR(CanIfRxPduConfig, AUTOMATIC) RxPduConfig[] =
{
    /* ThermalCAN */
    { /* 0 */
        CanIf_ThermalCAN_Commands_FrameTrig, /* CanIf Pdu Id */
        1, /* 0x00000001 CAN Id */
        6, /* DLC */
        FALSE, /* CanIfReadRxPduData */
        FALSE, /* CanIfReadRxPduNotifyStatus */
        STANDARD_CAN, /* CAN Id Type */
        CANIF_PDUR, /* RX user */
        PduR_CanIfRxIndication, /* User RX indication */
        0, /* CanIfCanRxPduHrhRef */
        PDUR_RX_Commands_10561_10897_CanIf_Com, /* PduIdRef */
        0, /* RxPduCanIdRange */
        0, /* CanIfRxPduDataBufferInd */
        NULL_PTR, /* RX Interrupt function pointer */
        0, /*Rx Interrupt State Manager index */
    },
    { /* 1 */
        CanIf_ThermalCAN_HeatTransfer_FrameTrig, /* CanIf Pdu Id */
        2, /* 0x00000002 CAN Id */
        8, /* DLC */
        FALSE, /* CanIfReadRxPduData */
        FALSE, /* CanIfReadRxPduNotifyStatus */
        STANDARD_CAN, /* CAN Id Type */
        CANIF_PDUR, /* RX user */
        PduR_CanIfRxIndication, /* User RX indication */
        0, /* CanIfCanRxPduHrhRef */
        PDUR_RX_HeatTransfer_10561_10897_CanIf_Com, /* PduIdRef */
        0, /* RxPduCanIdRange */
        0, /* CanIfRxPduDataBufferInd */
        NULL_PTR, /* RX Interrupt function pointer */
        0, /*Rx Interrupt State Manager index */
    },
    { /* 2 */
        CanIf_ThermalCAN_Traction_FrameTrig, /* CanIf Pdu Id */
        3, /* 0x00000003 CAN Id */
        4, /* DLC */
        FALSE, /* CanIfReadRxPduData */
        FALSE, /* CanIfReadRxPduNotifyStatus */
        STANDARD_CAN, /* CAN Id Type */
        CANIF_PDUR, /* RX user */
        PduR_CanIfRxIndication, /* User RX indication */
        0, /* CanIfCanRxPduHrhRef */
        PDUR_RX_Traction_10561_10897_CanIf_Com, /* PduIdRef */
        0, /* RxPduCanIdRange */
        0, /* CanIfRxPduDataBufferInd */
        NULL_PTR, /* RX Interrupt function pointer */
        0, /*Rx Interrupt State Manager index */
    },
};

UNUSED static VAR(CanIfHrhRangeConfig, AUTOMATIC) HrhRangeConfig0[1] = { 0 };  /* For C98 compatibility this array has length 1 */

static VAR(CanIfHrhConfig, AUTOMATIC) HrhConfig[] = {
    { /* ThermalCAN */
        0, /* CanIfHrhId */
        BASIC_CAN,       /* CanIfHrhType */
        FALSE,           /* CanIfSoftwareFilterHrh */
        0,               /* CanIfCanControllerHrhIdRef */
        0,               /* CanIfHrhIdSymRef */
        HrhRangeConfig0, /* HrhRangeConfig */
        0                /* CanIfNumberofHrhRange */
    },
};

static CanIfInitHohConfig InitHohConfig[] =
{
    {
            0,            /* RefConfigSet */
            HrhConfig,
            HthConfig
    }
};

static CanIfInitConfiguration InitConfiguration[] =
{
    {
            3, /* Number of CAN RX PDU IDs */
            4, /* Number of CAN TX PDU IDs */
            0, /* Number of dynamic CAN TX PDU IDs*/
            InitHohConfig,
            RxPduConfig,
            TxPduConfig
    }
};

static CanIfDriverConfig DriverConfig[1] =
{
    {
            FALSE, /* CanIfBusoffNotification */
            FALSE, /* CanIfReceiveIndication */
            FALSE, /* CanIfTransmitCancellation */
            FALSE, /* CanIfTxConfirmation */
            FALSE, /* CanIfWakeupNotification */
            0,     /* CanIfDriverNameRef */
            0      /* InitHohConfigRef */
    }
};

static CanIfDispatchConfig DispatchConfig[1] =
{
    {
            0,          /* CanIfDispatchUserCtrlBusOffName */
            UL_NONE,    /* DispatchUserCtrlBusOffUL */
            0,          /* CanIfDispatchUserValidateWakeupEventName */
            UL_NONE,    /* CanIfDispatchUserValidateWakeupEventUL */
            CanIf_TransmitFunction, /* CanIfDispatchTransmit */
            CanIf_RxIndication      /* CanIfDispatchRxIndication */
    }
};

static CanIfControllerConfig ControllerConfig[CHANNEL_ADDRESS_COUNT] =
{
     {
            FALSE, /* CanIfWakeupSupport */
            0,     /* CanIfControllerIdRef */
            0,     /* CanIfDriverNameRef */
            FALSE, /* CanIfRxObjectNeeded */
            TRUE,     /* CanIf_ControllerEnabledState */
            4,     /* Index in StateManager to handle ComControllerEnable state */
            0,    /* Index in StateManager for used credit counter */
            (DsTCanBoard)0 /* CanBoard */
    },
};

static CanIf_ConfigType ga_CanIfConfig[1] =
{
    {       /* ga_CanIfConfig */
            ControllerConfig,
            DispatchConfig,
            DriverConfig,
            InitConfiguration,
            ga_CanIfRxPduDataBuffer,
            ga_CanIfDynamicTxPduCanIdArray,
            ga_CanIfReadRxPduNotifyStatus,
            ga_CanIfReadTxPduNotifyStatus,
            3,
            ga_CanIfRxMetaData,
            ga_CanIfRxInterruptMetaData,
    }
};

UNUSED static uint32 gClusterId[CHANNEL_ADDRESS_COUNT] = { 1 };

void
CanIf_InitDefaultConfig(void)
{
    uint8 i;

    for (i = 0; i < CHANNEL_ADDRESS_COUNT; i++)
    {
      DsTCanBoard CanBoard;
      DsTCanCh    CanChannel;
      
#ifdef CANIF_ENABLE_PROFILING	
      dsProfilerWriteEvent(DsCanBoard_create_PROFILER_SRC, UserTimespanStart, 0u, i);
#endif
      DsCanBoard_create(&CanBoard, *gp_CanIf_ChannelAddress[i]);
#ifdef CANIF_ENABLE_PROFILING
      dsProfilerWriteEvent(DsCanBoard_create_PROFILER_SRC, UserTimespanEnd, 0u, i);
#endif
      
#ifdef CANIF_ENABLE_PROFILING	
      dsProfilerWriteEvent(DsCanCh_create_PROFILER_SRC, UserTimespanStart, 0u, i);
#endif
      DsCanCh_create(&CanChannel, CanBoard, *gp_CanIf_ChannelAddress[i]);
#ifdef CANIF_ENABLE_PROFILING
      dsProfilerWriteEvent(DsCanCh_create_PROFILER_SRC, UserTimespanEnd, 0u, i);
#endif
      
#if defined(HOST_DEBUG)
      {
        DsTCanBus pBus;
        DsCanBus_create(&pBus, gClusterId[i]);
        DsCanBus_connectChannel(pBus, CanChannel);
      }
#endif

      ga_CanIfConfig->ControllerConfig[i].CanBoard = CanBoard;
      ga_CanIfConfig->ControllerConfig[i].CanIfControllerIdRef = CanChannel;
    }
}

void
CanIf_Init(const void * ConfigStruct)
{
    INTENDED_UNREFERENCED_PARAMETER(ConfigStruct);
}

STATIC boolean doFirstStepInitialization = TRUE;

extern void* Bus_Configuration__1__10897_CanIfHthIdSymRef[1];

void CanIf_VariableInitialize(void)
{
    uint8 controllerState;

    /* do other modules need CanIf to be initialized earlier? */
    CanIf_InitFunction((const void *) ga_CanIfConfig);

    if (doFirstStepInitialization)
    {
        for (PduIdType Count = 0; Count < InitConfiguration[0].CanIfNumberOfCanTxPduIds; Count++)
        {
            if (HthConfig[Count].CanIfCanControllerIdRef != 0) continue;
            uint8 pduF = (uint8)(TxPduConfig[Count].CanIfCanTxPduIdCanId >> 16);
            if (!(TxPduConfig[Count].CanIfTxUserType == CANIF_J1939TP && (pduF == 0xEB || pduF == 0xEC)) &&
                !(TxPduConfig[Count].CanIfTxUserType == CANIF_CANTSYN))
            {
                HthConfig[Count].CanIfHthIdSymRef = Bus_Configuration__1__10897_CanIfHthIdSymRef[0];
                TxPduConfig[Count].QueueSize = 200;
            }
        }
        CanIf_InitController(0, 0);
#ifdef CANIF_ENABLE_PROFILING
        DsCanBoard_create_PROFILER_SRC = dsProfilerCreateSource(MACRO_NAME_TOSTR(ECU_ID)"_DsCanBoard_create");
        DsCanCh_create_PROFILER_SRC = dsProfilerCreateSource(MACRO_NAME_TOSTR(ECU_ID)"_DsCanCh_create");
#endif
    }
    CanIf_SetControllerMode(0, CANIF_CS_STARTED);
    CanIf_SetPduMode(0, CANIF_SET_RX_ONLINE);
    CanIf_SetPduMode(0, CANIF_SET_TX_ONLINE);/**/
    controllerState = TRUE;
    /* The Controller state is set to the default state depending on first or on every application start */
    StateManager_SetState_Mutex(4,controllerState);


    doFirstStepInitialization = FALSE;
}

/* [EOF] */
